
;;prototype dissimilarity data icon

(defproto dib-icon-proto () nil graph-stats-icon-proto)

(defmeth  dib-icon-proto :isnew 
  (w x y width height &key (title "Untitled") (state "gray") (draw t)
     (title-separation 2) (title-back-color nil))
  (send self :icon-color 'dissim-icon-color)
  (send self :icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 0 1 )
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 )  
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 

(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 )  
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 1 ) 
(1 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 1 0 0 1 ) 
(1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 0 0 1 ) 
(1 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 1 ) 
(1 0 0 1 0 1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 1 ) 
(1 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 1 ) 
(1 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 1 ) 
(1 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 1 0 0 1 ) 
(1 0 0 1 0 0 0 0 0 1 0 0 0 0 0 0 1 0 0 0 1 0 0 1 ) 
(1 0 0 1 0 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 1 0 0 1 ) 
(1 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0 0 1 ) 
(1 0 0 1 0 0 0 0 0 0 0 0 1 0 0 0 1 0 0 1 1 0 0 1 ) 
(1 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 1 0 1 1 0 0 0 1 ) 
(1 0 0 1 0 0 0 0 0 0 0 0 0 0 1 0 1 1 1 0 0 0 0 1 ) 
(1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )));31 24
  (send self :hi-icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) 
(1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 )  
(1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 )
(1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 )  
(1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 )
(1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 )  
(1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 )
(1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 )
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )
  
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )

(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)   
(1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1) 
(1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1) 
(1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 1 1 1) 
(1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 0 1 1 1) 
(1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 1 1 1) 
(1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1)
(1 1 1 0 1 0 1 1 1 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1) 
(1 1 1 0 1 1 0 1 1 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1) 
(1 1 1 0 1 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1) 
(1 1 1 0 1 1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 0 1 1 1) 
(1 1 1 0 1 1 1 1 1 0 1 1 1 1 1 1 0 1 1 1 0 1 1 1)
(1 1 1 0 1 1 1 1 1 1 0 1 1 1 1 1 0 1 1 1 0 1 1 1) 
(1 1 1 0 1 1 1 1 1 1 1 0 1 1 1 1 0 1 1 1 0 1 1 1) 
(1 1 1 0 1 1 1 1 1 1 1 1 0 1 1 1 0 1 1 0 0 1 1 1) 
(1 1 1 0 1 1 1 1 1 1 1 1 1 0 1 1 0 1 0 0 1 1 1 1) 
(1 1 1 0 1 1 1 1 1 1 1 1 1 1 0 1 0 0 0 1 1 1 1 1) 
(1 1 1 0 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 1 1 1 1) 
(1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)
(0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1)))
(send self :grey-icon (send self :make-tall-grey-icon))
  (call-next-method w x y width height :title title :draw draw)
  (send self :icon-state "selected")
  (send self :icon-type 4)
  (send self :title-separation title-separation)
  (send self :title-back-color title-back-color)
  (send self :graph-not-showable nil)
  (send self :draw t)
  self)


;;
;; DASH ICON
;;
(defproto dash-icon-proto '(datasheet) nil icon-proto)

(defmeth dash-icon-proto :datasheet (&optional (objid nil set))
  (if set (setf (slot-value 'datasheet) objid))
  (slot-value 'datasheet)) 

(defmeth  dash-icon-proto :isnew 
  (w x y width height &key (title "Untitled") (state "selected") (draw t)
     (title-separation 2) (title-back-color nil) (object nil))
;(format t "; ICONOBJ5.LSP|DASH-ICON-PROTO|ISNEW - OBJECT ~a ICON-NUMBER ~d WICONNUMBER ~D ;NICONS ~D~%" object (SEND SELF :ICON-NUMBER) (SEND *WORKMAP* :ICON-NUMBER) (SEND *WORKMAP* ;:NUM-ICONS))
  (send self :icon-number (1- (send *workmap* :num-icons)))
  (send self :window w)
  (send self :object (if object object *current-object*))
  (send object :dash-icon self)
  (send self :icon (send self :bitmap))
  (send self :hi-icon (send self :bitmap))
  (send self :grey-icon (send self :bitmap))
  (send self :draw-hi-icon x y)
  (call-next-method w x y width height :title title :draw draw)
  (send self :icon-state state)
  (send self :title-separation title-separation)
  (send self :title-back-color title-back-color)
  (send self :icon-type 9)
  (send self :draw t)
  )


(defmeth dash-icon-proto :draw-icon (x y)
  (send self :draw-dash-icon x y 'grey 'light-yellow 'white))

(defmeth dash-icon-proto :draw-hi-icon (x y)
  (send self :draw-dash-icon x y 'black 'yellow 'white))
  
(defmeth dash-icon-proto :draw-grey-icon (x y)
    (send self :draw-dash-icon x y 'black 'grey1 'grey1))


(defmeth dash-icon-proto :icon-pieces ()
  (let* ((h-border (matrix '(1 44) (repeat 1 44)))
         (v-border (matrix '(30 1) (repeat 1 30)))
         (black11 (repeat 1 11))
         (black2-yellow9 (combine '(1 1) (repeat 0 9)))
         (labels-bmp
          (matrix '(30 11) 
                  (combine black11
                           (repeat black2-yellow9 7)
                           (repeat black11 2)
                           (repeat black2-yellow9 19)
                           black11)))
         (names-types-bmp 
          (matrix '(9 32) 
                  (combine (repeat (combine (repeat 1 32) 
                                            (repeat (combine '(1 1) (repeat 0 29) '(1)) 3)
                                            )
                                   2) 
                           (repeat 1 32))))
         ;repeates 5 times, solid black row, 3 main rows
         
         (main-row 
               '(1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1))
         (datacells-bmp
          (matrix '(21 32) 
                  (combine (repeat (combine (repeat 1 32) 
                                            (repeat main-row 3)) 
                                   5)
                           (repeat 1 32)))))
    (list labels-bmp names-types-bmp datacells-bmp h-border v-border)))


(defmeth dash-icon-proto :make-icons ()
  (send dash-icon-proto :icon      (send dash-icon-proto :bitmap))
  (send dash-icon-proto :hi-icon   (send dash-icon-proto :bitmap))
  (send dash-icon-proto :grey-icon (send dash-icon-proto :bitmap))
  )

(defmeth dash-icon-proto :bitmap ()
  (let* ((piece (send self :icon-pieces))
         (labels (first piece))
         (names  (second piece))
         (data   (third  piece))
         (h-bord (fourth piece))
         (v-bord (fifth  piece))
         (bmp (bind-rows (bind-columns labels (bind-rows names data) v-bord) h-bord)))
    bmp))

(defmeth dash-icon-proto :draw-dash-icon (x y draw-color back-color-a back-color-b)
  (let* ((w (send self :window))
         (piece (send self :icon-pieces))
         (labels (first piece))
         (names  (second piece))
         (data   (third  piece))
         (h-bord (fourth piece))
         (v-bord (fifth  piece))
         )
        (send w :draw-color draw-color)
    (send w :back-color back-color-a)
    (send w :draw-bitmap labels x y)
    (send w :draw-bitmap names (+ x 11) y)
    (send w :back-color back-color-b)
    (send w :draw-bitmap data (+ x 11) (+ y  9))
    (send w :back-color 'white)
    (send w :back-color 'grey)
    (send w :draw-bitmap h-bord (+ x 1) (+ y 30))
    (send w :draw-bitmap v-bord (+ x 43) (+ y 1))
    (send w :draw-color 'grey)
    (send w :draw-bitmap h-bord (+ x 2) (+ y 31))
    (send w :draw-bitmap v-bord (+ x 44) (+ y 2))
    (send w :draw-color 'black)
    ))


(defmeth dash-icon-proto :draw-dash-icon (x y draw-color back-color-a back-color-b)
  (let* ((w (send self :window))
         (h-border (matrix '(1 43) (repeat 1 43)))
         (v-border (matrix '(30 1) (repeat 1 30)))
         (black11 (repeat 1 11))
         (black2-yellow9 (combine '(1 1) (repeat 0 9)))
         (leftmat 
          (matrix '(30 11) 
                  (combine black11
                           (repeat black2-yellow9 7)
                           (repeat black11 2)
                           (repeat black2-yellow9 19)
                           black11)))
         (toprightmat 
          (matrix '(9 32) 
                  (combine (repeat (combine (repeat 1 32) 
                                            (repeat (combine '(1 1) (repeat 0 29) '(1)) 3)
                                            )
                                   2) 
                           (repeat 1 32))))
         ;repeates 5 times, solid black row, 3 main rows
         
         (main-row 
               '(1 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 1))
         (submat
          (matrix '(21 32) 
                  (combine (repeat (combine (repeat 1 32) 
                                            (repeat main-row 3)) 
                                   5)
                           (repeat 1 32)))))
    (send w :draw-color draw-color)
    (send w :back-color back-color-a)
    (send w :draw-bitmap leftmat x y)
    (send w :draw-bitmap toprightmat (+ x 11) y)
    (send w :back-color back-color-b)
    (send w :draw-bitmap submat (+ x 11) (+ y  9))
    (send w :back-color 'grey)
    (send w :draw-bitmap h-border (+ x 1) (+ y 30))
    (send w :draw-bitmap v-border (+ x 43) (+ y 1))
    (send w :draw-color 'grey)
    (send w :draw-bitmap h-border (+ x 2) (+ y 31))
    (send w :draw-bitmap v-border (+ x 44) (+ y 2))
    (send w :draw-color 'black)
    (send w :back-color 'white)
    ))
    
(send dash-icon-proto :make-icons)

(defmeth dash-icon-proto :analysis (&optional (action nil set))
  (if set (setf (slot-value 'analysis) action))
  (slot-value 'analysis)) 

(defmeth dash-icon-proto :copy-tool (w)
  (let ((current-data-icon 
         (select (send w :icon-list) (send w :selected-icon)))
        )
  (send w :add-icon w
        (- (send current-data-icon :x) 8)
        (+ (send current-data-icon :y) 50)
        (send self :title)
        2)))



#|

;;###########################################################################
;;define prototype model icon object and it's bitmaps and methods
;; and ear icons
;;###########################################################################

(defproto mob-icon-proto '(icon-cap hi-icon-cap) nil graph-stats-icon-proto)

(defmeth mob-icon-proto :icon-cap (&optional (bitmatrix nil set))
  (if set (setf (slot-value 'icon-cap) bitmatrix ))
  (slot-value 'icon-cap)) 

(defmeth mob-icon-proto :hi-icon-cap (&optional (bitmatrix  nil set))
  (if set (setf (slot-value 'hi-icon-cap) bitmatrix ))
  (slot-value 'hi-icon-cap)) 

(defmeth  mob-icon-proto :isnew 
  (w x y width height &key (title "Untitled") (state "gray") (draw t)
     (title-separation 2) (title-back-color nil) (model-object nil))

  (setf (slot-value 'icon-cap) #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )  
))
(send self :hi-icon-cap) #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 ) 
(1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 ) 
(1 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 0 0 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 0 0 0 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 0 ) 
(1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 1 0 0 1 1 1 1 0 0 0 0 0 0 1 1 0 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 ) 
(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ) ))
  (send self :grey-icon (send self :make-long-grey-icon))
 
  (send self :icon  #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 0 0 1 1 1 1 1 0 0 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 1 1 1 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )  

(1 0 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 0 0 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 0 1 1 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 1 1 0 1 1 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 1 1 0 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 0 0 1 0 0 1 0 0 1 0 0 1 0 0 1 ) 
(1 0 0 1 1 1 1 1 1 0 0 1 1 1 0 0 1 1 1 1 1 0 0 1 ) 
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 )
(1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 )  
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )))
(send self :hi-icon #2A(
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )
(1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 )  
(1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 )
(1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 )  
(1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 )
(1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 )  
(1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 1 )
(1 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 0 1 )   
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )
 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 1 1 1 1 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 1 1 1 1 0 0 1 1 1 1 0 0 0 1 1 1 0 0 0 0 1 1 1 ) 
(1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 1 1 0 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 1 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 1 0 0 0 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 0 0 1 0 0 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 0 0 1 1 1 0 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 0 0 0 0 0 0 1 1 0 1 1 0 1 1 0 1 1 0 1 1 1 ) 
(1 1 1 0 0 0 0 0 0 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 ) 
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )
(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 )))
  (send self :grey-icon (send self :make-tall-grey-icon))
  (call-next-method w x y width height :title title :draw draw)
  (send self :icon-state "selected")
  (send self :icon-type 3)
  (send self :title-separation title-separation)
  (send self :title-back-color title-back-color)
  (send self :object model-object)
  (send self :draw draw)
  self)
|#